<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// File path or URL
$fileTarget = ""; // can be local path or remote URL

include("./config.php"); // Include Telegram credentials

// Helper: check if target is a URL
function isUrl($path) {
    return (bool)preg_match('/^https?:\/\//i', $path);
}

// Helper: stream remote file with cURL
function streamRemoteFile($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, false);
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_BUFFERSIZE, 8192);
    curl_setopt($ch, CURLOPT_TIMEOUT, 0);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    // Stream directly to output
    curl_setopt($ch, CURLOPT_WRITEFUNCTION, function($ch, $data) {
        echo $data;
        return strlen($data);
    });

    curl_exec($ch);
    curl_close($ch);
}

if (isUrl($fileTarget)) {
    // --- Remote file handling ---
    $fileName = basename(parse_url($fileTarget, PHP_URL_PATH));
    $mimeType = "application/octet-stream"; // fallback for remote files

    // Send headers
    header('Content-Description: File Transfer');
    header('Content-Type: ' . $mimeType);
    header('Content-Disposition: attachment; filename="' . $fileName . '"');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Expires: 0');

    flush();

    // Telegram notification
    $ip      = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $browser = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
    $time    = date('Y-m-d H:i:s');

    $message = "✅ Download Completed!\n"
             . "File: " . $fileName . "\n"
             . "IP: " . $ip . "\n"
             . "Browser: " . $browser . "\n"
             . "Time: " . $time;

    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    $data = [
        'chat_id' => $chatId,
        'text'    => $message
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 1);
    curl_exec($ch);
    curl_close($ch);

    // Try readfile first, fallback to cURL if disabled
    if (ini_get('allow_url_fopen')) {
        readfile($fileTarget);
    } else {
        streamRemoteFile($fileTarget);
    }
    exit;

} else {
    // --- Local file handling ---
    $filePath = $fileTarget;

    if (file_exists($filePath)) {
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mimeType = finfo_file($finfo, $filePath);
        finfo_close($finfo);

        header('Content-Description: File Transfer');
        header('Content-Type: ' . $mimeType);
        header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
        header('Content-Length: ' . filesize($filePath));
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Expires: 0');

        flush();

        // Telegram notification
        $ip      = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
        $browser = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
        $time    = date('Y-m-d H:i:s');

        $message = "✅ Download Completed!\n"
                 . "File: " . basename($filePath) . "\n"
                 . "IP: " . $ip . "\n"
                 . "Browser: " . $browser . "\n"
                 . "Time: " . $time;

        $url = "https://api.telegram.org/bot$botToken/sendMessage";
        $data = [
            'chat_id' => $chatId,
            'text'    => $message
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 1);
        curl_exec($ch);
        curl_close($ch);

        readfile($filePath);
        exit;
    } else {
        echo "File not found: " . htmlspecialchars($filePath);
    }
}
?>
